@extends('layout')
@section('contents')
 
<div class="row pt-3">
    <div class="col-12"><h3>Contacts</h3></div>
</div>
<div class="row pt-3">
    <div class="col-12 text-right text-end">
        <a type="button" href="{{url('/members/add')}}" class="btn btn-primary">New Contact</a>
        <a type="button" href="{{url('/message')}}" class="btn btn-warning">Send Message for New Contacts</a>
    </div>
</div>
<div class="row pt-3">
    @foreach($stats as $ky=>$row) 
        <div class="col-2 p-2 m-2" style="border-radius:5px; border:1px solid gray;background:{{$row['color']}}">
            <a href="{{url('/filter/'. $ky)}}" style="text-decoration:none;color:black"> 
                <div>
                <h6>{{$row['label']}}</h6>
                <h4>{{$row['val']}}</h4>
                </div>
            </a>
            </div>
        </a>
    @endforeach
</div>
<div class="row pt-3">
    <div class="col-12">
        <table id="dataTable" class="dataTable table table-stripped">
        
            <thead>
                <tr>
                    <th align="left">Sr #</th>
                    <th>Salutation</th>
                    <th align="left">Name</th>
                    <th>Mobile Number</th>
                    <th>Status</th>
                    <th>Created On</th>
                    <th>Message Sent on</th>
                    <th>Attending?</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $ctr=1; ?>
                @foreach($data as $row)
                    <tr>
                        <td>{{$ctr}}</td>
                        <td>{{$row['salutation']}}</td>
                        <td align="left">{{$row['name']}}</td>
                        <td>{{$row['country']}}{{$row['phone']}}</td>
                        <td>{{$row['status']}}</td>
                        <td>{{date('d/m/Y', strtotime($row['created_at']))}} </td>
                        <td>
                            @if($row['status'] == "Sent")
                                {{ date('d/m/Y', strtotime($row['created_at']))}}
                            @endif
                        </td>
                        <td>
                            @if($row['attending'] == 10)
                                Attending 
                            @endif 
                            @if($row['attending'] == 20)
                                Not Attending 
                            @endif 
                            @if($row['attending'] == 0 && $row['status'] == "Sent")
                                Not Confirmed 
                            @endif 
                        </td>
                        <td>
                            <a href="{{url('/members/edit/'. $row['id'])}}"><i class="fa fa-edit"></i></a>
                            <a href="{{url('/members/resend/'. $row['id'])}}" title="Resend Message"><i class="fa fa-refresh"></i></a>
                        </td>
                    </tr>
                    <?php $ctr++; ?>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection